// |reftest| shell-option(--enable-arraybuffer-resizable) shell-option(--enable-float16array) skip-if(!this.hasOwnProperty('Float16Array')||!ArrayBuffer.prototype.resize||!xulRuntime.shell) -- Float16Array,resizable-arraybuffer is not enabled unconditionally, requires shell-options
// Copyright (C) 2024 Kevin Gibbons. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
esid: sec-dataview.prototype.getfloat16
description: Throws a TypeError if buffer is out-of-bounds
features: [Float16Array, DataView, ArrayBuffer, resizable-arraybuffer]
---*/

assert.sameValue(
  typeof ArrayBuffer.prototype.resize,
  'function',
  'implements ArrayBuffer.prototype.resize'
);

var buffer = new ArrayBuffer(24, {maxByteLength: 32});
var sample = new DataView(buffer, 0, 16);

try {
  buffer.resize(32);
} catch (_) {}

assert.sameValue(sample.getFloat16(0), 0, 'following grow');

try {
  buffer.resize(16);
} catch (_) {}

assert.sameValue(sample.getFloat16(0), 0, 'following shrink (within bounds)');

var expectedError;
try {
  buffer.resize(8);
  expectedError = TypeError;
} catch (_) {
  expectedError = Test262Error;
}

assert.throws(expectedError, function() {
  sample.getFloat16(0);
  throw new Test262Error('the operation completed successfully');
});

reportCompare(0, 0);
