//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
	"net/http"
	"net/url"
	"regexp"
)

// PortalSettingsServer is a fake server for instances of the armapimanagement.PortalSettingsClient type.
type PortalSettingsServer struct {
	// ListByService is the fake for method PortalSettingsClient.ListByService
	// HTTP status codes to indicate success: http.StatusOK
	ListByService func(ctx context.Context, resourceGroupName string, serviceName string, options *armapimanagement.PortalSettingsClientListByServiceOptions) (resp azfake.Responder[armapimanagement.PortalSettingsClientListByServiceResponse], errResp azfake.ErrorResponder)
}

// NewPortalSettingsServerTransport creates a new instance of PortalSettingsServerTransport with the provided implementation.
// The returned PortalSettingsServerTransport instance is connected to an instance of armapimanagement.PortalSettingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPortalSettingsServerTransport(srv *PortalSettingsServer) *PortalSettingsServerTransport {
	return &PortalSettingsServerTransport{srv: srv}
}

// PortalSettingsServerTransport connects instances of armapimanagement.PortalSettingsClient to instances of PortalSettingsServer.
// Don't use this type directly, use NewPortalSettingsServerTransport instead.
type PortalSettingsServerTransport struct {
	srv *PortalSettingsServer
}

// Do implements the policy.Transporter interface for PortalSettingsServerTransport.
func (p *PortalSettingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PortalSettingsClient.ListByService":
		resp, err = p.dispatchListByService(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PortalSettingsServerTransport) dispatchListByService(req *http.Request) (*http.Response, error) {
	if p.srv.ListByService == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByService not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/portalsettings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.ListByService(req.Context(), resourceGroupNameParam, serviceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PortalSettingsCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
