//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridcontainerservice

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// VMSKUsClient contains the methods for the VMSKUs group.
// Don't use this type directly, use NewVMSKUsClient() instead.
type VMSKUsClient struct {
	internal *arm.Client
}

// NewVMSKUsClient creates a new instance of VMSKUsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewVMSKUsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*VMSKUsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &VMSKUsClient{
		internal: cl,
	}
	return client, nil
}

// NewListPager - Lists the supported VM SKUs from the underlying custom location
//
// Generated from API version 2023-11-15-preview
//   - customLocationResourceURI - The fully qualified Azure Resource manager identifier of the custom location resource.
//   - options - VMSKUsClientListOptions contains the optional parameters for the VMSKUsClient.NewListPager method.
func (client *VMSKUsClient) NewListPager(customLocationResourceURI string, options *VMSKUsClientListOptions) *runtime.Pager[VMSKUsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[VMSKUsClientListResponse]{
		More: func(page VMSKUsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VMSKUsClientListResponse) (VMSKUsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "VMSKUsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, customLocationResourceURI, options)
			}, nil)
			if err != nil {
				return VMSKUsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *VMSKUsClient) listCreateRequest(ctx context.Context, customLocationResourceURI string, options *VMSKUsClientListOptions) (*policy.Request, error) {
	urlPath := "/{customLocationResourceUri}/providers/Microsoft.HybridContainerService/skus"
	urlPath = strings.ReplaceAll(urlPath, "{customLocationResourceUri}", customLocationResourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *VMSKUsClient) listHandleResponse(resp *http.Response) (VMSKUsClientListResponse, error) {
	result := VMSKUsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMSKUProfileList); err != nil {
		return VMSKUsClientListResponse{}, err
	}
	return result, nil
}
