//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/labservices/armlabservices"
	"net/http"
	"net/url"
	"regexp"
)

// VirtualMachinesServer is a fake server for instances of the armlabservices.VirtualMachinesClient type.
type VirtualMachinesServer struct {
	// Get is the fake for method VirtualMachinesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string, options *armlabservices.VirtualMachinesClientGetOptions) (resp azfake.Responder[armlabservices.VirtualMachinesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByLabPager is the fake for method VirtualMachinesClient.NewListByLabPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByLabPager func(resourceGroupName string, labName string, options *armlabservices.VirtualMachinesClientListByLabOptions) (resp azfake.PagerResponder[armlabservices.VirtualMachinesClientListByLabResponse])

	// BeginRedeploy is the fake for method VirtualMachinesClient.BeginRedeploy
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRedeploy func(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string, options *armlabservices.VirtualMachinesClientBeginRedeployOptions) (resp azfake.PollerResponder[armlabservices.VirtualMachinesClientRedeployResponse], errResp azfake.ErrorResponder)

	// BeginReimage is the fake for method VirtualMachinesClient.BeginReimage
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginReimage func(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string, options *armlabservices.VirtualMachinesClientBeginReimageOptions) (resp azfake.PollerResponder[armlabservices.VirtualMachinesClientReimageResponse], errResp azfake.ErrorResponder)

	// BeginResetPassword is the fake for method VirtualMachinesClient.BeginResetPassword
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResetPassword func(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string, body armlabservices.ResetPasswordBody, options *armlabservices.VirtualMachinesClientBeginResetPasswordOptions) (resp azfake.PollerResponder[armlabservices.VirtualMachinesClientResetPasswordResponse], errResp azfake.ErrorResponder)

	// BeginStart is the fake for method VirtualMachinesClient.BeginStart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStart func(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string, options *armlabservices.VirtualMachinesClientBeginStartOptions) (resp azfake.PollerResponder[armlabservices.VirtualMachinesClientStartResponse], errResp azfake.ErrorResponder)

	// BeginStop is the fake for method VirtualMachinesClient.BeginStop
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStop func(ctx context.Context, resourceGroupName string, labName string, virtualMachineName string, options *armlabservices.VirtualMachinesClientBeginStopOptions) (resp azfake.PollerResponder[armlabservices.VirtualMachinesClientStopResponse], errResp azfake.ErrorResponder)
}

// NewVirtualMachinesServerTransport creates a new instance of VirtualMachinesServerTransport with the provided implementation.
// The returned VirtualMachinesServerTransport instance is connected to an instance of armlabservices.VirtualMachinesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVirtualMachinesServerTransport(srv *VirtualMachinesServer) *VirtualMachinesServerTransport {
	return &VirtualMachinesServerTransport{
		srv:                srv,
		newListByLabPager:  newTracker[azfake.PagerResponder[armlabservices.VirtualMachinesClientListByLabResponse]](),
		beginRedeploy:      newTracker[azfake.PollerResponder[armlabservices.VirtualMachinesClientRedeployResponse]](),
		beginReimage:       newTracker[azfake.PollerResponder[armlabservices.VirtualMachinesClientReimageResponse]](),
		beginResetPassword: newTracker[azfake.PollerResponder[armlabservices.VirtualMachinesClientResetPasswordResponse]](),
		beginStart:         newTracker[azfake.PollerResponder[armlabservices.VirtualMachinesClientStartResponse]](),
		beginStop:          newTracker[azfake.PollerResponder[armlabservices.VirtualMachinesClientStopResponse]](),
	}
}

// VirtualMachinesServerTransport connects instances of armlabservices.VirtualMachinesClient to instances of VirtualMachinesServer.
// Don't use this type directly, use NewVirtualMachinesServerTransport instead.
type VirtualMachinesServerTransport struct {
	srv                *VirtualMachinesServer
	newListByLabPager  *tracker[azfake.PagerResponder[armlabservices.VirtualMachinesClientListByLabResponse]]
	beginRedeploy      *tracker[azfake.PollerResponder[armlabservices.VirtualMachinesClientRedeployResponse]]
	beginReimage       *tracker[azfake.PollerResponder[armlabservices.VirtualMachinesClientReimageResponse]]
	beginResetPassword *tracker[azfake.PollerResponder[armlabservices.VirtualMachinesClientResetPasswordResponse]]
	beginStart         *tracker[azfake.PollerResponder[armlabservices.VirtualMachinesClientStartResponse]]
	beginStop          *tracker[azfake.PollerResponder[armlabservices.VirtualMachinesClientStopResponse]]
}

// Do implements the policy.Transporter interface for VirtualMachinesServerTransport.
func (v *VirtualMachinesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VirtualMachinesClient.Get":
		resp, err = v.dispatchGet(req)
	case "VirtualMachinesClient.NewListByLabPager":
		resp, err = v.dispatchNewListByLabPager(req)
	case "VirtualMachinesClient.BeginRedeploy":
		resp, err = v.dispatchBeginRedeploy(req)
	case "VirtualMachinesClient.BeginReimage":
		resp, err = v.dispatchBeginReimage(req)
	case "VirtualMachinesClient.BeginResetPassword":
		resp, err = v.dispatchBeginResetPassword(req)
	case "VirtualMachinesClient.BeginStart":
		resp, err = v.dispatchBeginStart(req)
	case "VirtualMachinesClient.BeginStop":
		resp, err = v.dispatchBeginStop(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines/(?P<virtualMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
	if err != nil {
		return nil, err
	}
	virtualMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), resourceGroupNameParam, labNameParam, virtualMachineNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VirtualMachine, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchNewListByLabPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListByLabPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByLabPager not implemented")}
	}
	newListByLabPager := v.newListByLabPager.get(req)
	if newListByLabPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armlabservices.VirtualMachinesClientListByLabOptions
		if filterParam != nil {
			options = &armlabservices.VirtualMachinesClientListByLabOptions{
				Filter: filterParam,
			}
		}
		resp := v.srv.NewListByLabPager(resourceGroupNameParam, labNameParam, options)
		newListByLabPager = &resp
		v.newListByLabPager.add(req, newListByLabPager)
		server.PagerResponderInjectNextLinks(newListByLabPager, req, func(page *armlabservices.VirtualMachinesClientListByLabResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByLabPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListByLabPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByLabPager) {
		v.newListByLabPager.remove(req)
	}
	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginRedeploy(req *http.Request) (*http.Response, error) {
	if v.srv.BeginRedeploy == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRedeploy not implemented")}
	}
	beginRedeploy := v.beginRedeploy.get(req)
	if beginRedeploy == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines/(?P<virtualMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/redeploy`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
		if err != nil {
			return nil, err
		}
		virtualMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginRedeploy(req.Context(), resourceGroupNameParam, labNameParam, virtualMachineNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRedeploy = &respr
		v.beginRedeploy.add(req, beginRedeploy)
	}

	resp, err := server.PollerResponderNext(beginRedeploy, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginRedeploy.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRedeploy) {
		v.beginRedeploy.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginReimage(req *http.Request) (*http.Response, error) {
	if v.srv.BeginReimage == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginReimage not implemented")}
	}
	beginReimage := v.beginReimage.get(req)
	if beginReimage == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines/(?P<virtualMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reimage`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
		if err != nil {
			return nil, err
		}
		virtualMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginReimage(req.Context(), resourceGroupNameParam, labNameParam, virtualMachineNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginReimage = &respr
		v.beginReimage.add(req, beginReimage)
	}

	resp, err := server.PollerResponderNext(beginReimage, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginReimage.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginReimage) {
		v.beginReimage.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginResetPassword(req *http.Request) (*http.Response, error) {
	if v.srv.BeginResetPassword == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResetPassword not implemented")}
	}
	beginResetPassword := v.beginResetPassword.get(req)
	if beginResetPassword == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines/(?P<virtualMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resetPassword`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armlabservices.ResetPasswordBody](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
		if err != nil {
			return nil, err
		}
		virtualMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginResetPassword(req.Context(), resourceGroupNameParam, labNameParam, virtualMachineNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResetPassword = &respr
		v.beginResetPassword.add(req, beginResetPassword)
	}

	resp, err := server.PollerResponderNext(beginResetPassword, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginResetPassword.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResetPassword) {
		v.beginResetPassword.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginStart(req *http.Request) (*http.Response, error) {
	if v.srv.BeginStart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStart not implemented")}
	}
	beginStart := v.beginStart.get(req)
	if beginStart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines/(?P<virtualMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
		if err != nil {
			return nil, err
		}
		virtualMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginStart(req.Context(), resourceGroupNameParam, labNameParam, virtualMachineNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStart = &respr
		v.beginStart.add(req, beginStart)
	}

	resp, err := server.PollerResponderNext(beginStart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginStart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStart) {
		v.beginStart.remove(req)
	}

	return resp, nil
}

func (v *VirtualMachinesServerTransport) dispatchBeginStop(req *http.Request) (*http.Response, error) {
	if v.srv.BeginStop == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStop not implemented")}
	}
	beginStop := v.beginStop.get(req)
	if beginStop == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines/(?P<virtualMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
		if err != nil {
			return nil, err
		}
		virtualMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginStop(req.Context(), resourceGroupNameParam, labNameParam, virtualMachineNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStop = &respr
		v.beginStop.add(req, beginStop)
	}

	resp, err := server.PollerResponderNext(beginStop, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginStop.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStop) {
		v.beginStop.remove(req)
	}

	return resp, nil
}
