//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// IntegrationRuntimesServer is a fake server for instances of the armsynapse.IntegrationRuntimesClient type.
type IntegrationRuntimesServer struct {
	// BeginCreate is the fake for method IntegrationRuntimesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, integrationRuntime armsynapse.IntegrationRuntimeResource, options *armsynapse.IntegrationRuntimesClientBeginCreateOptions) (resp azfake.PollerResponder[armsynapse.IntegrationRuntimesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method IntegrationRuntimesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, options *armsynapse.IntegrationRuntimesClientBeginDeleteOptions) (resp azfake.PollerResponder[armsynapse.IntegrationRuntimesClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDisableInteractiveQuery is the fake for method IntegrationRuntimesClient.BeginDisableInteractiveQuery
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDisableInteractiveQuery func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, options *armsynapse.IntegrationRuntimesClientBeginDisableInteractiveQueryOptions) (resp azfake.PollerResponder[armsynapse.IntegrationRuntimesClientDisableInteractiveQueryResponse], errResp azfake.ErrorResponder)

	// BeginEnableInteractiveQuery is the fake for method IntegrationRuntimesClient.BeginEnableInteractiveQuery
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginEnableInteractiveQuery func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, options *armsynapse.IntegrationRuntimesClientBeginEnableInteractiveQueryOptions) (resp azfake.PollerResponder[armsynapse.IntegrationRuntimesClientEnableInteractiveQueryResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method IntegrationRuntimesClient.Get
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNotModified
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, options *armsynapse.IntegrationRuntimesClientGetOptions) (resp azfake.Responder[armsynapse.IntegrationRuntimesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByWorkspacePager is the fake for method IntegrationRuntimesClient.NewListByWorkspacePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByWorkspacePager func(resourceGroupName string, workspaceName string, options *armsynapse.IntegrationRuntimesClientListByWorkspaceOptions) (resp azfake.PagerResponder[armsynapse.IntegrationRuntimesClientListByWorkspaceResponse])

	// ListOutboundNetworkDependenciesEndpoints is the fake for method IntegrationRuntimesClient.ListOutboundNetworkDependenciesEndpoints
	// HTTP status codes to indicate success: http.StatusOK
	ListOutboundNetworkDependenciesEndpoints func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, options *armsynapse.IntegrationRuntimesClientListOutboundNetworkDependenciesEndpointsOptions) (resp azfake.Responder[armsynapse.IntegrationRuntimesClientListOutboundNetworkDependenciesEndpointsResponse], errResp azfake.ErrorResponder)

	// BeginStart is the fake for method IntegrationRuntimesClient.BeginStart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStart func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, options *armsynapse.IntegrationRuntimesClientBeginStartOptions) (resp azfake.PollerResponder[armsynapse.IntegrationRuntimesClientStartResponse], errResp azfake.ErrorResponder)

	// BeginStop is the fake for method IntegrationRuntimesClient.BeginStop
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStop func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, options *armsynapse.IntegrationRuntimesClientBeginStopOptions) (resp azfake.PollerResponder[armsynapse.IntegrationRuntimesClientStopResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method IntegrationRuntimesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, updateIntegrationRuntimeRequest armsynapse.UpdateIntegrationRuntimeRequest, options *armsynapse.IntegrationRuntimesClientUpdateOptions) (resp azfake.Responder[armsynapse.IntegrationRuntimesClientUpdateResponse], errResp azfake.ErrorResponder)

	// Upgrade is the fake for method IntegrationRuntimesClient.Upgrade
	// HTTP status codes to indicate success: http.StatusOK
	Upgrade func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, options *armsynapse.IntegrationRuntimesClientUpgradeOptions) (resp azfake.Responder[armsynapse.IntegrationRuntimesClientUpgradeResponse], errResp azfake.ErrorResponder)
}

// NewIntegrationRuntimesServerTransport creates a new instance of IntegrationRuntimesServerTransport with the provided implementation.
// The returned IntegrationRuntimesServerTransport instance is connected to an instance of armsynapse.IntegrationRuntimesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewIntegrationRuntimesServerTransport(srv *IntegrationRuntimesServer) *IntegrationRuntimesServerTransport {
	return &IntegrationRuntimesServerTransport{
		srv:                          srv,
		beginCreate:                  newTracker[azfake.PollerResponder[armsynapse.IntegrationRuntimesClientCreateResponse]](),
		beginDelete:                  newTracker[azfake.PollerResponder[armsynapse.IntegrationRuntimesClientDeleteResponse]](),
		beginDisableInteractiveQuery: newTracker[azfake.PollerResponder[armsynapse.IntegrationRuntimesClientDisableInteractiveQueryResponse]](),
		beginEnableInteractiveQuery:  newTracker[azfake.PollerResponder[armsynapse.IntegrationRuntimesClientEnableInteractiveQueryResponse]](),
		newListByWorkspacePager:      newTracker[azfake.PagerResponder[armsynapse.IntegrationRuntimesClientListByWorkspaceResponse]](),
		beginStart:                   newTracker[azfake.PollerResponder[armsynapse.IntegrationRuntimesClientStartResponse]](),
		beginStop:                    newTracker[azfake.PollerResponder[armsynapse.IntegrationRuntimesClientStopResponse]](),
	}
}

// IntegrationRuntimesServerTransport connects instances of armsynapse.IntegrationRuntimesClient to instances of IntegrationRuntimesServer.
// Don't use this type directly, use NewIntegrationRuntimesServerTransport instead.
type IntegrationRuntimesServerTransport struct {
	srv                          *IntegrationRuntimesServer
	beginCreate                  *tracker[azfake.PollerResponder[armsynapse.IntegrationRuntimesClientCreateResponse]]
	beginDelete                  *tracker[azfake.PollerResponder[armsynapse.IntegrationRuntimesClientDeleteResponse]]
	beginDisableInteractiveQuery *tracker[azfake.PollerResponder[armsynapse.IntegrationRuntimesClientDisableInteractiveQueryResponse]]
	beginEnableInteractiveQuery  *tracker[azfake.PollerResponder[armsynapse.IntegrationRuntimesClientEnableInteractiveQueryResponse]]
	newListByWorkspacePager      *tracker[azfake.PagerResponder[armsynapse.IntegrationRuntimesClientListByWorkspaceResponse]]
	beginStart                   *tracker[azfake.PollerResponder[armsynapse.IntegrationRuntimesClientStartResponse]]
	beginStop                    *tracker[azfake.PollerResponder[armsynapse.IntegrationRuntimesClientStopResponse]]
}

// Do implements the policy.Transporter interface for IntegrationRuntimesServerTransport.
func (i *IntegrationRuntimesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "IntegrationRuntimesClient.BeginCreate":
		resp, err = i.dispatchBeginCreate(req)
	case "IntegrationRuntimesClient.BeginDelete":
		resp, err = i.dispatchBeginDelete(req)
	case "IntegrationRuntimesClient.BeginDisableInteractiveQuery":
		resp, err = i.dispatchBeginDisableInteractiveQuery(req)
	case "IntegrationRuntimesClient.BeginEnableInteractiveQuery":
		resp, err = i.dispatchBeginEnableInteractiveQuery(req)
	case "IntegrationRuntimesClient.Get":
		resp, err = i.dispatchGet(req)
	case "IntegrationRuntimesClient.NewListByWorkspacePager":
		resp, err = i.dispatchNewListByWorkspacePager(req)
	case "IntegrationRuntimesClient.ListOutboundNetworkDependenciesEndpoints":
		resp, err = i.dispatchListOutboundNetworkDependenciesEndpoints(req)
	case "IntegrationRuntimesClient.BeginStart":
		resp, err = i.dispatchBeginStart(req)
	case "IntegrationRuntimesClient.BeginStop":
		resp, err = i.dispatchBeginStop(req)
	case "IntegrationRuntimesClient.Update":
		resp, err = i.dispatchUpdate(req)
	case "IntegrationRuntimesClient.Upgrade":
		resp, err = i.dispatchUpgrade(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *IntegrationRuntimesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if i.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := i.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsynapse.IntegrationRuntimeResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		var options *armsynapse.IntegrationRuntimesClientBeginCreateOptions
		if ifMatchParam != nil {
			options = &armsynapse.IntegrationRuntimesClientBeginCreateOptions{
				IfMatch: ifMatchParam,
			}
		}
		respr, errRespr := i.srv.BeginCreate(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		i.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		i.beginCreate.remove(req)
	}

	return resp, nil
}

func (i *IntegrationRuntimesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if i.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := i.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginDelete(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		i.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		i.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		i.beginDelete.remove(req)
	}

	return resp, nil
}

func (i *IntegrationRuntimesServerTransport) dispatchBeginDisableInteractiveQuery(req *http.Request) (*http.Response, error) {
	if i.srv.BeginDisableInteractiveQuery == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDisableInteractiveQuery not implemented")}
	}
	beginDisableInteractiveQuery := i.beginDisableInteractiveQuery.get(req)
	if beginDisableInteractiveQuery == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/disableInteractiveQuery`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginDisableInteractiveQuery(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDisableInteractiveQuery = &respr
		i.beginDisableInteractiveQuery.add(req, beginDisableInteractiveQuery)
	}

	resp, err := server.PollerResponderNext(beginDisableInteractiveQuery, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginDisableInteractiveQuery.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDisableInteractiveQuery) {
		i.beginDisableInteractiveQuery.remove(req)
	}

	return resp, nil
}

func (i *IntegrationRuntimesServerTransport) dispatchBeginEnableInteractiveQuery(req *http.Request) (*http.Response, error) {
	if i.srv.BeginEnableInteractiveQuery == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginEnableInteractiveQuery not implemented")}
	}
	beginEnableInteractiveQuery := i.beginEnableInteractiveQuery.get(req)
	if beginEnableInteractiveQuery == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/enableInteractiveQuery`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginEnableInteractiveQuery(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginEnableInteractiveQuery = &respr
		i.beginEnableInteractiveQuery.add(req, beginEnableInteractiveQuery)
	}

	resp, err := server.PollerResponderNext(beginEnableInteractiveQuery, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginEnableInteractiveQuery.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginEnableInteractiveQuery) {
		i.beginEnableInteractiveQuery.remove(req)
	}

	return resp, nil
}

func (i *IntegrationRuntimesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
	if err != nil {
		return nil, err
	}
	ifNoneMatchParam := getOptional(getHeaderValue(req.Header, "If-None-Match"))
	var options *armsynapse.IntegrationRuntimesClientGetOptions
	if ifNoneMatchParam != nil {
		options = &armsynapse.IntegrationRuntimesClientGetOptions{
			IfNoneMatch: ifNoneMatchParam,
		}
	}
	respr, errRespr := i.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNotModified}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNotModified", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IntegrationRuntimeResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IntegrationRuntimesServerTransport) dispatchNewListByWorkspacePager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListByWorkspacePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByWorkspacePager not implemented")}
	}
	newListByWorkspacePager := i.newListByWorkspacePager.get(req)
	if newListByWorkspacePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListByWorkspacePager(resourceGroupNameParam, workspaceNameParam, nil)
		newListByWorkspacePager = &resp
		i.newListByWorkspacePager.add(req, newListByWorkspacePager)
		server.PagerResponderInjectNextLinks(newListByWorkspacePager, req, func(page *armsynapse.IntegrationRuntimesClientListByWorkspaceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByWorkspacePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListByWorkspacePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByWorkspacePager) {
		i.newListByWorkspacePager.remove(req)
	}
	return resp, nil
}

func (i *IntegrationRuntimesServerTransport) dispatchListOutboundNetworkDependenciesEndpoints(req *http.Request) (*http.Response, error) {
	if i.srv.ListOutboundNetworkDependenciesEndpoints == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListOutboundNetworkDependenciesEndpoints not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outboundNetworkDependenciesEndpoints`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.ListOutboundNetworkDependenciesEndpoints(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IntegrationRuntimesServerTransport) dispatchBeginStart(req *http.Request) (*http.Response, error) {
	if i.srv.BeginStart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStart not implemented")}
	}
	beginStart := i.beginStart.get(req)
	if beginStart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginStart(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStart = &respr
		i.beginStart.add(req, beginStart)
	}

	resp, err := server.PollerResponderNext(beginStart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginStart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStart) {
		i.beginStart.remove(req)
	}

	return resp, nil
}

func (i *IntegrationRuntimesServerTransport) dispatchBeginStop(req *http.Request) (*http.Response, error) {
	if i.srv.BeginStop == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStop not implemented")}
	}
	beginStop := i.beginStop.get(req)
	if beginStop == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginStop(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStop = &respr
		i.beginStop.add(req, beginStop)
	}

	resp, err := server.PollerResponderNext(beginStop, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginStop.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStop) {
		i.beginStop.remove(req)
	}

	return resp, nil
}

func (i *IntegrationRuntimesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if i.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsynapse.UpdateIntegrationRuntimeRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Update(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IntegrationRuntimeResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IntegrationRuntimesServerTransport) dispatchUpgrade(req *http.Request) (*http.Response, error) {
	if i.srv.Upgrade == nil {
		return nil, &nonRetriableError{errors.New("fake for method Upgrade not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/upgrade`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Upgrade(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
