% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_cvd.R
\name{simulate_cvd}
\alias{simulate_cvd}
\alias{deutan}
\alias{protan}
\alias{tritan}
\alias{interpolate_cvd_transform}
\title{Simulate Color Vision Deficiency}
\usage{
simulate_cvd(col, cvd_transform, linear = TRUE)

deutan(col, severity = 1, linear = TRUE)

protan(col, severity = 1, linear = TRUE)

tritan(col, severity = 1, linear = TRUE)

interpolate_cvd_transform(cvd, severity = 1)
}
\arguments{
\item{col}{vector of R colors. Can be any of the three kinds of R colors,
i.e., either a color name (an element of \code{\link[grDevices]{colors}}), a hexadecimal (hex)
string of the form \code{"#rrggbb"} or \code{"#rrggbbaa"} (see \code{\link[grDevices]{rgb}}), or
an integer \code{i} meaning \code{palette()[i]}. Additionally, \code{col} can be
a formal \code{\link[colorspace]{color-class}} object or a matrix with three named
rows (or columns) containing R/G/B (0-255) values.}

\item{cvd_transform}{numeric 3x3 matrix, specifying the color vision deficiency transform matrix.}

\item{linear}{logical. Should the color vision deficiency transformation be applied to the
linearized RGB coordinates (default)? If \code{FALSE}, the transformation is applied to the
gamma-corrected sRGB coordinates (which was the default up to version 2.0-3 of the package).}

\item{severity}{numeric. Severity of the color vision defect, a number between 0 and 1.}

\item{cvd}{list of cvd transformation matrices. See \code{\link{cvd}} for available options.}
}
\value{
A color object as specified in the input \code{col} (hexadecimal string, RGB matrix,
or formal color class) with simulated color vision deficiency.
}
\description{
Transformation of R colors by simulating color vision deficiencies,
based on a CVD transform matrix.
}
\details{
Using the physiologically-based model for simulating color vision deficiency (CVD)
of Machado et al. (2009), different kinds of limitations can be
emulated: deuteranope (green cone cells defective), protanope (red cone cells defective),
and tritanope (blue cone cells defective).
The workhorse function to do so is \code{simulate_cvd} which can take any vector
of valid R colors and transform them according to a certain CVD transformation
matrix (see \code{\link{cvd}}) and transformation equation.

The functions \code{deutan}, \code{protan}, and \code{tritan} are the high-level functions for
simulating the corresponding kind of colorblindness with a given severity.
Internally, they all call \code{simulate_cvd} along with a (possibly interpolated)
version of the matrices from \code{\link{cvd}}. Matrix interpolation can be carried out with
the function \code{interpolate_cvd_transform} (see examples).

If input \code{col} is a matrix with three rows named \code{R}, \code{G}, and
\code{B} (top down) they are interpreted as Red-Green-Blue values within the
range \code{[0-255]}. Then the CVD transformation is applied directly to these
coordinates avoiding any further conversions.

Finally, if \code{col} is a formal \code{\link[colorspace]{color-class}} object, then its
coordinates are transformed to (s)RGB coordinates, as described above, and returned as a formal
object of the same class after the color vision deficiency simulation.

Up to version 2.0-3 of the package, the CVD transformations had been applied
directly to the gamma-corrected sRGB coordinates (corresponding to the hex coordinates
of the colors), following the illustrations of Machado et al. (2009). However,
the paper implicitly relies on a linear RGB space (see page 1294, column 1) where their
linear matrix transformations for simulating color vision deficiencies are applied.
Therefore, starting from version 2.1-0 of the package, a new argument \code{linear = TRUE}
has been added that first maps the provided colors to linearized RGB coordinates, applies
the color vision deficiency transformation, and then maps back to gamma-corrected sRGB
coordinates. Optionally, \code{linear = FALSE} can be used to restore the behavior
from previous versions. For most colors the difference between the two strategies is
negligible but for some highly-saturated colors it becomes more noticable, e.g., for
red, purple, or orange.
}
\examples{
# simulate color-vision deficiency by calling `simulate_cvd` with specified matrix
simulate_cvd(c("#005000", "blue", "#00BB00"), tritanomaly_cvd["6"][[1]])

# simulate color-vision deficiency by calling the shortcut high-level function
tritan(c("#005000", "blue", "#00BB00"), severity = 0.6)

# simulate color-vision deficiency by calling `simulate_cvd` with interpolated cvd matrix
simulate_cvd(c("#005000", "blue", "#00BB00"),
             interpolate_cvd_transform(tritanomaly_cvd, severity = 0.6))

# apply CVD directly on wide RGB matrix (with R/G/B channels in rows)
RGB <- diag(3) * 255
rownames(RGB) <- c("R", "G", "B")
deutan(RGB)

}
\references{
Machado GM, Oliveira MM, Fernandes LAF (2009).
  \dQuote{A Physiologically-Based Model for Simulation of Color Vision Deficiency.}
  \emph{IEEE Transactions on Visualization and Computer Graphics}. \bold{15}(6), 1291--1298.
  \doi{10.1109/TVCG.2009.113}
  Online version with supplements at
  \url{http://www.inf.ufrgs.br/~oliveira/pubs_files/CVD_Simulation/CVD_Simulation.html}.

Zeileis A, Fisher JC, Hornik K, Ihaka R, McWhite CD, Murrell P, Stauffer R, Wilke CO (2020).
  \dQuote{colorspace: A Toolbox for Manipulating and Assessing Colors and Palettes.}
  \emph{Journal of Statistical Software}, \bold{96}(1), 1--49.
  \doi{10.18637/jss.v096.i01}
}
\seealso{
\code{\link{cvd}}
}
\keyword{colorblind}
\keyword{colors}
\keyword{cvd}
