% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upload.R
\name{upload}
\alias{upload}
\title{upload file}
\usage{
upload(path, type = NULL)
}
\arguments{
\item{path}{(character) a single path, file must exist}

\item{type}{(character) a file type, guessed by \link[mime:guess_type]{mime::guess_type} if
not given}
}
\description{
upload file
}
\examples{
\dontrun{
# image
path <- file.path(Sys.getenv("R_DOC_DIR"), "html/logo.jpg")
(x <- HttpClient$new(url = "https://hb.opencpu.org"))
res <- x$post(path = "post", body = list(y = upload(path)))
res$content

# text file, in a list
file <- upload(system.file("CITATION"))
res <- x$post(path = "post", body = list(y = file))
jsonlite::fromJSON(res$parse("UTF-8"))

# text file, as data
res <- x$post(path = "post", body = file)
jsonlite::fromJSON(res$parse("UTF-8"))
}
}
