% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confpred.R
\name{confpred}
\alias{confpred}
\title{Conformal prediction}
\usage{
confpred(object, data, newdata = data, alpha = 0.05, mad, ...)
}
\arguments{
\item{object}{Model object (lm, glm or similar with predict method) or formula (lm)}

\item{data}{data.frame}

\item{newdata}{New data.frame to make predictions for}

\item{alpha}{Level of prediction interval}

\item{mad}{Conditional model (formula) for the MAD (locally-weighted CP)}

\item{...}{Additional arguments to lower level functions}
}
\value{
data.frame with fitted (fit), lower (lwr) and upper (upr) predictions bands.
}
\description{
Conformal predicions using locally weighted conformal inference with a split-conformal algorithm
}
\examples{
set.seed(123)
n <- 200
x <- seq(0,6,length.out=n)
delta <- 3
ss <- exp(-1+1.5*cos((x-delta)))
ee <- rnorm(n,sd=ss)
y <- (x-delta)+3*cos(x+4.5-delta)+ee
d <- data.frame(y=y,x=x)

newd <- data.frame(x=seq(0,6,length.out=50))
cc <- confpred(lm(y~splines::ns(x,knots=c(1,3,5)),data=d), data=d, newdata=newd)
if (interactive()) {
plot(y~x,pch=16,col=lava::Col("black"),ylim=c(-10,10),xlab="X",ylab="Y")
with(cc,
     lava::confband(newd$x,lwr,upr,fit,
        lwd=3,polygon=TRUE,col=Col("blue"),border=FALSE))
}
}
