
2021-05-18 Triage Log

A lot of noise in the benchmark results this week. We are discussing ([zulip archive](https://zulip-archive.rust-lang.org/247081tcompilerperformance/06104coercionsdebugnoise.html), [live zulip](https://rust-lang.zulipchat.com/#narrow/stream/247081-t-compiler.2Fperformance/topic/coercions-debug.20noise)) how best to update the benchmark set to eliminate the noisy cases that are bouncing around. Beyond that, some large improvements to a few individual benchmarks.

The memory usage ([max-rss](https://perf.rust-lang.org/?start=2021-05-11&end=2021-05-18&absolute=true&stat=max-rss)) seemed largely flat. Except for an upward trend on `tuple-stess` that indicates 4% more memory from a week ago.

Triage done by **@pnkfelix**.
Revision range: [382f748f23979e37e3e012b090e5a0313463f182..25a277f03df7e44643ddfcc240d034409cb2f505](https://perf.rust-lang.org/?start=382f748f23979e37e3e012b090e5a0313463f182&end=25a277f03df7e44643ddfcc240d034409cb2f505&absolute=false&stat=instructions%3Au)

5 Regressions, 7 Improvements, 2 Mixed
1 of them in rollups

#### Regressions

Reachable statics have reachable initializers [#84549](https://github.com/rust-lang/rust/issues/84549)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=747a5d2a5d6693f5e9426524b0dab34eb1587377&end=f8e1e9238077a829ce1ac0cc1f2c7e0eaa4e679d&stat=instructions:u) (up to 1.4% on `incr-unchanged` builds of `ctfe-stress-4-opt`)
- `ctfe-stress-4-debug` also saw a 1.2% regression in its `incr-unchanged` builds.
- Other benchmarks were not significantly impacted.
- The two regressions were [anticipated](https://github.com/rust-lang/rust/pull/84549#issuecomment-832760519) from a perf run on the PR itself.

#### Improvements

have on_completion record subcycles [#85186](https://github.com/rust-lang/rust/issues/85186)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=952c5732c2d25a875f90e5cd5dd29a1a21c1d4a2&end=6d395a1c2946c79966490f5b1e6e619d3a713e6b&stat=instructions:u) (up to -9.4% on `incr-unchanged` builds of `syn-opt`)
- No other benchmark was significantly impacted.
- The improvement was [anticipated](https://github.com/rust-lang/rust/pull/85186#issuecomment-840666856) from a perf run on the PR itself.
- (But this PR was about incr-comp correctness, not performance.)

Store VariantIdx to distinguish enum variants [#85195](https://github.com/rust-lang/rust/issues/85195)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=17f30e5451f581d753899d2f628e5be354df33cd&end=754d17121d04d02bee634558129110b68fa95b00&stat=instructions:u) (up to -24.4% on `full` builds of `match-stress-enum-check`)
- All of the `match-stress-enum` variants observed a similar improvement. This makes sense since that is a microbenchmark stressing the compilation of `match` expressions.
- The improvement was [anticipated](https://github.com/rust-lang/rust/pull/85195#issuecomment-839356544) from a perf run on the PR itself.

Do not allocate or unwind after fork [#81858](https://github.com/rust-lang/rust/issues/81858)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=8cf990c9b5c59f25c806fad9f4466f9d6509bbea&end=d565c7488749fd0e998d6be21efeb20354e4696d&stat=instructions:u) (up to -1.1% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo-debug`)
- No other benchmark was significantly impacted.
- Seems like noise.

#### Mixed

BTree: no longer copy keys and values before dropping them [#84904](https://github.com/rust-lang/rust/issues/84904)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=ba8d7e2cb7cfc87070585c17cd0aa4ae7f091a08&end=5c029265465301fe9cb3960ce2a5da6c99b8dcf2&stat=instructions:u) (up to -1.2% on `incr-unchanged` builds of `ctfe-stress-4-check` and `ctfe-stress-4-opt` and `ctfe-stress-4-debug`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=ba8d7e2cb7cfc87070585c17cd0aa4ae7f091a08&end=5c029265465301fe9cb3960ce2a5da6c99b8dcf2&stat=instructions:u) (up to 1.2% on `incr-patched: println` builds of `cargo-opt`)
- These changes were [anticipated](https://github.com/rust-lang/rust/pull/84904#issuecomment-837892302) from a perf run on the PR itself.

rustc_codegen_ssa: only create backend `BasicBlock`s as-needed. [#84993](https://github.com/rust-lang/rust/issues/84993)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=fe72845f7bb6a77b9e671e6a4f32fe714962cec4&end=a55748ffe94e71f841c7b1d752779b0db138b342&stat=instructions:u) (up to -4.3% on `full` builds of `syn-opt`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=fe72845f7bb6a77b9e671e6a4f32fe714962cec4&end=a55748ffe94e71f841c7b1d752779b0db138b342&stat=instructions:u) (up to 1.8% on `full` builds of `deeply-nested-async-check`)
- The improvement to `syn-opt` was [anticipated](https://github.com/rust-lang/rust/pull/84993#issuecomment-841687503) from perf runs on the PR itself.
- The regression on `deeply-nested-async-check` was not predicted by that run.

#### Suspicious Noise

##### coercions

rustc_driver cleanup [#83610](https://github.com/rust-lang/rust/issues/83610)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=c1e7e361f7cddd1fe9b3bfef71a6539d2570e4fb&end=ac923d94f86a6f7c881ecbedcd0a68d7986a35bd&stat=instructions:u) (up to 1.7% on `full` builds of `coercions-debug`)
- No other benchmark was significantly impacted.
- No performance regression was expected here.
- Seems like noise.

Add auto traits and clone trait migrations for RFC2229 [#84730](https://github.com/rust-lang/rust/issues/84730)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e1ff91f439bc09f566da211c6449821b4e949279&end=28e2b29b8952485679367cc05699fb5154f4e5c3&stat=instructions:u) (up to 1.4% on `full` builds of `coercions-debug`)
- No other benchmark was significantly impacted.
- No performance regression was expected here.
- Seems like noise.

Provide ExitStatusError [#82973](https://github.com/rust-lang/rust/issues/82973)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=5f10d310f475b3ba583b9c590b8d19f6c2fde28f&end=25a277f03df7e44643ddfcc240d034409cb2f505&stat=instructions:u) (up to 1.7% on `full` builds of `coercions-debug`)
- No other benchmark was significantly impacted.
- No performance regression was expected here.
- Seems like noise.

Fix `--remap-path-prefix` not correctly remapping `rust-src` component paths and unify handling of path mapping with virtualized paths [#83813](https://github.com/rust-lang/rust/issues/83813)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=ac923d94f86a6f7c881ecbedcd0a68d7986a35bd&end=e1ff91f439bc09f566da211c6449821b4e949279&stat=instructions:u) (up to -1.4% on `full` builds of `coercions-debug`)
- No other benchmark was significantly impacted.
- Seems like noise.

Rollup of 5 pull requests [#85231](https://github.com/rust-lang/rust/issues/85231)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=28e2b29b8952485679367cc05699fb5154f4e5c3&end=70e52caed91a43fc01867921e67fcd3478056edd&stat=instructions:u) (up to -1.7% on `full` builds of `coercions-debug`)
- No other benchmark was significantly impacted.
- Seems like noise.

Rollup of 8 pull requests [#85414](https://github.com/rust-lang/rust/issues/85414)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=fa72878a61f2b0a2127fe7d700724642fc79ec66&end=3e99439f4dacc8ba0d2ca48d221694362d587927&stat=instructions:u) (up to -1.1% on `incr-full` builds of `coercions-debug`)
- `coercions-check` and `coercions-opt` had smaller improvements, -0.7% and -0.5%, respectively.
- No other benchmark was significantly impacted.
- Seems like noise.


##### html5ever

Add support for const operands and options to global_asm! [#84107](https://github.com/rust-lang/rust/issues/84107)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=6d395a1c2946c79966490f5b1e6e619d3a713e6b&end=17f30e5451f581d753899d2f628e5be354df33cd&stat=instructions:u) (up to 1.4% on `full` builds of `html5ever-opt`)
- No other benchmark was significantly impacted.
- No performance regression was expected here.
- Seems like noise.

Update cc crate [#85190](https://github.com/rust-lang/rust/issues/85190)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=754d17121d04d02bee634558129110b68fa95b00&end=91f2e2d21820ff9946f27aa743911d7344caa0e0&stat=instructions:u) (up to -1.2% on `full` builds of `html5ever-opt`)
- `coercions-debug` also saw a -1.0% improvement on its `full` builds.
- Based on the corresponding regressions above, seems like noise.



#### Nags requiring follow up

- Double-check whether regression to `deeply-nested-async-check` from [#84993](https://github.com/rust-lang/rust/issues/84993) is noise or something real.

- Look into the 4% `tuple-stress` regression. The first seems like gradual creep, plus a 3% jump that seems to be associated with [#84571](https://github.com/rust-lang/rust/pull/84571), "Parse unnamed fields of struct and union type." (Perhaps its inherent given the nature of that microbenchmark, but some other benchmarks also had their [memory usage impacted](https://perf.rust-lang.org/compare.html?start=44ec846f4ea68ffa6d06e7d68f078bd3cc59d4ec&end=9964284fed181676300aad693449f5b751e35ff2&stat=max-rss).
